@extends('layouts.theme')

@php
    $seo_title = App\seo::first();
@endphp

@section('title', isset($seo_title->meta_home) ? $seo_title->meta_home : '')

@section('main-wrapper')
<!-- main wrapper -->
<section id="main-wrapper" class="main-wrapper home-page">
    <div id="home-out-section-slider" class="home-out-section-slider home-out-section owl-carousel">
        @if (isset($blocks) && count($blocks) > 0)
            @foreach ($blocks as $block)
                <div class="slider-block">
                    <div class="home-out-section-img">
                        <img src="{{ url('images/main-home/'.(isset($block->image) ? $block->image : 'default.jpg')) }}" class="img-responsive" alt="">
                        <div class="overlay-bg {{ isset($block->left) && $block->left == 1 ? 'gredient-overlay-left' : 'gredient-overlay-right' }}"></div>
                        <div class="home-out-section-dtl">
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-md-6 col-sm-7 {{ isset($block->left) && $block->left == 1 ? 'col-md-offset-6 col-sm-offset-6 col-sm-6 col-md-6 text-right' : '' }}">
                                        <h2 class="section-heading">{{ isset($block->heading) ? $block->heading : '' }}</h2>
                                        <p class="section-dtl {{ isset($block->left) && $block->left == 1 ? 'pad-lt-100' : '' }}">
                                            {{ isset($block->detail) ? str_replace('&nbsp;', '', strip_tags($block->detail)) : '' }}
                                        </p>
                                        @if (isset($block->button) && $block->button == 1)
                                            @if (isset($block->button_link) && $block->button_link == 'login')
                                                @guest
                                                    <a href="{{ url('login') }}" class="btn btn-prime">{{ isset($block->button_text) ? $block->button_text : '' }}</a>
                                                @endguest
                                            @else
                                                @guest
                                                    <a href="{{ url('register') }}" class="btn btn-prime">{{ isset($block->button_text) ? $block->button_text : '' }}</a>
                                                @endguest
                                            @endif
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>

    <!-- Pricing plan main block -->
    @php
        $ps = App\PackageSetting::first();
    @endphp
    @if(isset($remove_subscription) && $remove_subscription == 0) 
        @if(isset($plans) && count($plans) > 0)
            <div class="purchase-plan-main-block main-home-section-plans">
                <div class="panel-setting-main-block panel-subscribe">
                    <div class="container-fluid">
                        <div class="plan-block-dtl">
                            <h3 class="plan-dtl-heading text-center">{{ isset($ps->heading) ? $ps->heading : '' }}</h3>
                            <div class="plan-dtl-list text-white">
                                {{ isset($ps->detail) ? str_replace('&nbsp;', '', strip_tags($ps->detail)) : '' }}
                            </div>
                        </div>
                        @if(Auth::check())
                            @php  
                                $id = Auth::user()->id ?? null;
                                $getuserplan = $id ? App\PaypalSubscription::where('status','=','1')->where('user_id',$id)->orderBy('id','ASC')->first() : null;
                            @endphp
                        @endif
                        @php
                            $today = date('Y-m-d H:i:s');
                        @endphp
                        <div class="snip1404">
                            <div id="purchase-slider" class="purchase-slider-block owl-carousel">
                                @foreach($plans as $plan)
                                    @if(isset($plan->delete_status) && $plan->delete_status == 1)
                                        @if(isset($plan->status) && $plan->status != 'inactive')
                                            <div class="item">
                                                <div class="main-plan-section 
                                                    @if(isset($getuserplan['package_id']) && $getuserplan['package_id'] == $plan->id && isset($getuserplan->status) && $getuserplan->status == '1' && $today < $getuserplan->subscription_to) 
                                                        active-plan 
                                                    @endif">
                                                    <header>
                                                        <h4 class="plan-home-title">{{ $plan->name ?? '' }}</h4>
                                                        <div class="plan-cost">
                                                            <span class="plan-price">
                                                                @if(Session::has('current_currency'))
                                                                    {{ currency($plan->amount ?? 0, $from = $plan->currency ?? 'USD', $to = ucfirst(Session::get('current_currency')), $format = true) }}
                                                                </span>
                                                                <span class="plan-type">
                                                                    {{ currency($plan->amount ?? 0, $from = $plan->currency ?? 'USD', $to = ucfirst(Session::get('current_currency')), $format = true) }}/{{ $plan->interval ?? '' }}
                                                                @else
                                                                    {{ $plan->currency_symbol ?? '' }}{{ $plan->amount ?? 0 }}
                                                                </span>
                                                                <span class="plan-type">
                                                                    {{ $plan->currency_symbol ?? '' }} {{ isset($plan->amount, $plan->interval_count) ? number_format(($plan->amount) / ($plan->interval_count), 2) : 0 }}/{{ $plan->interval ?? '' }}
                                                                @endif
                                                            </span>
                                                        </div>
                                                    </header>

                                                    @php
                                                        $planFeatures = $plan->feature ?? [];
                                                        $features = App\PackageFeature::whereIn('id', $planFeatures)->pluck('name') ?? [];
                                                    @endphp
                                                    @if(isset($features) && count($features) > 0)                        
                                                        <ul class="plan-features">
                                                            @foreach ($features as $feature)
                                                                <li><i class="fa fa-check"></i> {{ $feature }}</li>
                                                            @endforeach
                                                        </ul>
                                                    @endif

                                                    @auth
                                                        @if(isset($getuserplan['package_id']) && $getuserplan['package_id'] == $plan->id && isset($getuserplan->status) && $getuserplan->status == "1" && $today <= $getuserplan->subscription_to )
                                                            <div class="plan-select"><a class="btn btn-prime btn-prime-bg">{{__('Already Subscribe')}}</a></div>
                                                        @else
                                                            @if(isset($plan->free) && $plan->free == 1 && $plan->status == 'upcoming')
                                                                <div class="plan-select"><a href="#">{{__('COMING SOON!')}}</a></div> 
                                                            @elseif(isset($plan->free) && $plan->free == 1 && $plan->status == 'active')
                                                                <form action="{{ route('free.package.subscription', $plan->id) }}" method="POST">
                                                                    @csrf
                                                                    <div class="plan-select btn-prime-subs">
                                                                        <a class="btn btn-prime">
                                                                            <input type="submit" class="btn-subscribe" value="{{__('Subscribe')}}">
                                                                        </a>
                                                                    </div>
                                                                </form>
                                                            @elseif(isset($plan->status) && $plan->status == 'upcoming')
                                                                <div class="plan-select"><a href="#">{{__('COMING SOON!')}}</a></div> 
                                                            @else
                                                                <div class="plan-select"><a href="{{ route('get_payment', $plan->id) }}" class="btn btn-prime">{{__('Subscribe')}}</a></div>
                                                            @endif
                                                        @endif
                                                    @else
                                                        @if(isset($plan->status) && $plan->status == 'upcoming')
                                                            <div class="plan-select"><a href="#">{{__('COMING SOON!')}}</a></div> 
                                                        @else
                                                            <div class="plan-select"><a href="{{ route('register') }}">{{__('Register Now')}}</a></div>
                                                        @endif
                                                    @endauth
                                                </div>
                                            </div>
                                        @endif
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endif
</section>
<!-- end main wrapper -->
@endsection

@section('script')
<script>
@if(isset(Auth::user()->multiplescreen))
    @if(isset(Auth::user()->multiplescreen->activescreen) && Auth::user()->multiplescreen->activescreen != NULL)
        $(document).ready(function(){
            $('#showM').hide();
        });
    @else
        $(document).ready(function(){
            $('#showM').modal();
        });
    @endif
@endif
</script>
@endsection
